/*
  LuxTag Camera.js
  
  
*/

// global variables.
var version_num = "0.1";

var camera_distributions = ["uniform", "exponential", "inverse exponential", "gaussian", "inverse gaussian"];

// preset
//var shutter_presets = ["full frame", "half frame", "quarter frame", "1/25", "1/30", "1/45", "1/60", "1/85", "1/125", "1/250", "1/500"];
var shutter_presets = ["full frame", "1/25", "1/30", "1/45", "1/60", "1/85", "1/125", "1/250", "1/500"];

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Camera ]");
	
	tag.addParameterBool("use near/far clip", 1, 0, 1, true, false);
	
	tag.addParameterSeparator("orthographic option");
	tag.addParameterFloat("ortho scale", 1, 0.01, 10000, true, false);
	
	tag.addParameterSeparator("dof option");
	tag.addParameterBool("autofocus", 0, 0, 1, true, false);
	tag.addParameterInt("blades", 6, 0, 16, true, false);
	tag.addParameterSelector("distribution", camera_distributions, true, false);
	tag.addParameterInt("power", 1, 0, 512, true, false);
	
	tag.addParameterSeparator("shift option");
	tag.addParameterBool("use shift", 0, 0, 1, true, false);
	tag.addParameterFloat("shift X",0, -2, 2, true, false);
	tag.addParameterFloat("shift Y",0, -2, 2, true, false);
	tag.addParameterBool("use aspect ratio", 0, 0, 1, true, false);
	tag.addParameterFloat("aspect ratio", 1.3333, 0.0001, 3.0, true, false);
	
	tag.addParameterSeparator("motion blur option");
	tag.addParameterBool("use motion blur", 0, 0, 1, true, false);
	tag.addParameterFloat("shutteropen", 0.0, 0, 100, true, false);
	tag.addParameterFloat("shutterclose", 1.0, 0, 100, true, false);
	
	tag.addParameterSeparator("calc. motion blur");
	tag.addParameterFloat("fps", 30, 1, 600, true, false);
	tag.addParameterSelector("shutter",shutter_presets, true, false);
	tag.addParameterButton("calc shutter open/close", "calc", "calcShutterOpenClose");
}

function calcShutterOpenClose( tag ) {
	var presets = shutter_presets[ parseInt( tag.getParameter("shutter") ) ];
	var fps = tag.getParameter("fps");
	
	switch (presets) {
		case 'full frame':
			tag.setParameter("shutterclose", 1.0);
			break;
		case 'half frame':
			tag.setParameter("shutterclose", 0.5);
			break;
		case 'quarter frame':
			tag.setParameter("shutterclose", 0.25);
			break;
		case '1/25':
			tag.setParameter("shutterclose", 1/25*fps);
			break;
		case '1/30':
			tag.setParameter("shutterclose", 1/30*fps);
			break;
		case '1/45':
			tag.setParameter("shutterclose", 1/45*fps);
			break;
		case '1/60':
			tag.setParameter("shutterclose", 1/60*fps);
			break;
		case '1/85':
			tag.setParameter("shutterclose", 1/85*fps);
			break;
		case '1/125':
			tag.setParameter("shutterclose", 1/125*fps);
			break;
		case '1/250':
			tag.setParameter("shutterclose", 1/250*fps);
			break;
		case '1/500':
			tag.setParameter("shutterclose", 1/500*fps);
			break;
	}
}
